package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	dictsproto "a.yandex-team.ru/travel/proto/avia/wizard"
)

type (
	pointPair        [2]string
	routeCountMapper map[pointPair]int

	RouteCount struct {
		routeCountMapper routeCountMapper
	}
)

func NewRouteCount() *RouteCount {
	return &RouteCount{make(routeCountMapper)}
}

func (ref *RouteCount) GetCount(settlementKeyFrom, settlementKeyTo string) int {
	pair := pointPair{settlementKeyFrom, settlementKeyTo}
	return ref.routeCountMapper[pair]
}

func (ref *RouteCount) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewRouteCount()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *RouteCount) Write(b []byte) (int, error) {
	message := new(dictsproto.TRouteCount)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("RouteCount:Write: %w", err)
	}
	pair := pointPair{message.PointFrom, message.PointTo}
	ref.routeCountMapper[pair] = int(message.Count)
	return len(b), nil
}
