package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type idToSettlementBigImage map[int]*models.SettlementBigImage

type SettlementBigImage struct {
	idToSettlementBigImage idToSettlementBigImage
}

func NewSettlementBigImage() *SettlementBigImage {
	return &SettlementBigImage{
		idToSettlementBigImage: make(idToSettlementBigImage),
	}
}

func (ref *SettlementBigImage) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewSettlementBigImage()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *SettlementBigImage) Write(b []byte) (int, error) {
	message := new(dictsproto.TSettlementBigImage)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("SettlementBigImage:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.idToSettlementBigImage[model.ID] = model
	return len(b), nil
}

func (ref *SettlementBigImage) convertProtoReferenceToModel(proto *dictsproto.TSettlementBigImage) *models.SettlementBigImage {
	reference := new(models.SettlementBigImage)
	reference.ID = int(proto.Id)
	reference.SettlementID = int(proto.SettlementId)
	reference.URL2 = proto.Url2
	return reference
}
