package references

import (
	"fmt"
	"sort"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/avia/wizard"
)

type settlementsOrderedByPopular []models.SettlementPopularity

func (s settlementsOrderedByPopular) Len() int           { return len(s) }
func (s settlementsOrderedByPopular) Swap(i, j int)      { s[i], s[j] = s[j], s[i] }
func (s settlementsOrderedByPopular) Less(i, j int) bool { return s[i].Popularity < s[j].Popularity }

type SettlementPopularities struct {
	orderedPopularities settlementsOrderedByPopular
}

func NewSettlementPopularities() *SettlementPopularities {
	return &SettlementPopularities{}
}

type SettlementPopularitiesContext struct {
	orderedPopularities settlementsOrderedByPopular
}

func (ref *SettlementPopularities) GetOrderedPopularities() []models.SettlementPopularity {
	return ref.orderedPopularities
}

func (ref *SettlementPopularities) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewSettlementPopularities()
	if err := iterator.Populate(newState); err != nil {
		return err
	}

	sort.Stable(newState.orderedPopularities)
	*ref = *newState
	return nil
}

func (ref *SettlementPopularities) Write(b []byte) (int, error) {
	message := new(dictsproto.TSettlementNational)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("SettlementPopularitiesContext:Write: %w", err)
	}
	if message.Arrival {
		ref.orderedPopularities = append(ref.orderedPopularities, ref.convertProtoReferenceToModel(message))
	}
	return len(b), nil
}

func (ref *SettlementPopularities) convertProtoReferenceToModel(proto *dictsproto.TSettlementNational) (reference models.SettlementPopularity) {
	reference.SettlementID = int(proto.SettlementID)
	reference.Popularity = int(proto.Popularity)
	reference.NationalVersion = proto.NationalVersion
	return
}
