package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type stations []*models.Station

type Station struct {
	stations stations
}

func NewStation() *Station {
	return &Station{
		stations: make(stations, 0),
	}
}

func (ref *Station) GetAll() []*models.Station {
	return ref.stations
}

func (ref *Station) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewStation()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *Station) Write(b []byte) (int, error) {
	message := new(dictsproto.TStation)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("Station:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.stations = append(ref.stations, &model)
	return len(b), nil
}

func (ref *Station) convertProtoReferenceToModel(proto *dictsproto.TStation) (reference models.Station) {
	reference.ID = int(proto.Id)
	reference.MajorityID = int(proto.MajorityId)
	reference.SettlementID = int(proto.SettlementId)
	reference.TTypeID = int(proto.TTypeId)
	reference.Hidden = proto.Hidden > 0
	reference.RegionID = int(proto.RegionId)
	reference.CountryID = int(proto.CountryId)
	reference.TimeZone = proto.TimeZone
	reference.Title = proto.Title
	reference.NewLTitleID = int(proto.NewLTitleID)
	reference.StationTypeID = int(proto.StationTypeID)
	reference.TitleRuPrepositionVVoNa = proto.TitleRuPrepositionVVoNa
	return
}
