package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type stationCodes []*models.StationCode

type StationCode struct {
	stationCodes stationCodes
}

func NewStationCode() *StationCode {
	return &StationCode{
		stationCodes: make(stationCodes, 0),
	}
}

func (ref *StationCode) GetAll() stationCodes {
	return ref.stationCodes
}

func (ref *StationCode) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewStationCode()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *StationCode) Write(b []byte) (int, error) {
	message := new(dictsproto.TStationCode)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("StationCode:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.stationCodes = append(ref.stationCodes, model)
	return len(b), nil
}

func (ref *StationCode) convertProtoReferenceToModel(proto *dictsproto.TStationCode) *models.StationCode {
	return &models.StationCode{
		ID:        int(proto.Id),
		StationID: int(proto.StationId),
		SystemID:  int(proto.SystemId),
		Code:      proto.Code,
	}
}
