package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type stationToSettlement []*models.StationToSettlement

type StationToSettlement struct {
	stationToSettlement stationToSettlement
}

func (ref *StationToSettlement) GetAll() []*models.StationToSettlement {
	return ref.stationToSettlement
}

func NewStationToSettlement() *StationToSettlement {
	return &StationToSettlement{
		stationToSettlement: make(stationToSettlement, 0),
	}
}

func (ref *StationToSettlement) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewStationToSettlement()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *StationToSettlement) Write(b []byte) (int, error) {
	message := new(dictsproto.TStation2Settlement)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("StationToSettlement:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.stationToSettlement = append(ref.stationToSettlement, model)
	return len(b), nil
}

func (ref *StationToSettlement) convertProtoReferenceToModel(proto *dictsproto.TStation2Settlement) *models.StationToSettlement {
	return &models.StationToSettlement{
		ID:           int(proto.Id),
		StationID:    int(proto.StationId),
		SettlementID: int(proto.SettlementId),
	}
}
