package references

import (
	"fmt"
	"strings"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type TranslatedTitle struct {
	translatedTitles []*models.TranslatedTitle
}

func NewTranslatedTitle() *TranslatedTitle {
	return &TranslatedTitle{}
}

func (ref *TranslatedTitle) GetAll() []*models.TranslatedTitle {
	return ref.translatedTitles
}

func (ref *TranslatedTitle) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewTranslatedTitle()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *TranslatedTitle) Write(b []byte) (int, error) {
	message := new(dictsproto.TTranslatedTitle)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("TranslatedTitle:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.translatedTitles = append(ref.translatedTitles, model)
	return len(b), nil
}

func (ref *TranslatedTitle) convertProtoReferenceToModel(proto *dictsproto.TTranslatedTitle) *models.TranslatedTitle {
	reference := new(models.TranslatedTitle)
	reference.ID = int(proto.Id)
	reference.RuNominative = proto.RuNominative
	reference.RuGenitive = proto.RuGenitive
	reference.RuDative = proto.RuDative
	reference.RuAccusative = proto.RuAccusative
	reference.RuLocative = proto.RuLocative

	reference.EnNominative = proto.EnNominative

	reference.TrNominative = proto.TrNominative

	reference.UkNominative = proto.UkNominative
	reference.UkAccusative = proto.UkAccusative

	reference.DeNominative = proto.DeNominative
	reference.LangCaseMap = map[string]string{
		strings.ToLower("RuNominative"): proto.RuNominative,
		strings.ToLower("RuGenitive"):   proto.RuGenitive,
		strings.ToLower("RuDative"):     proto.RuDative,
		strings.ToLower("RuAccusative"): proto.RuAccusative,
		strings.ToLower("RuLocative"):   proto.RuLocative,

		strings.ToLower("EnNominative"): proto.EnNominative,

		strings.ToLower("TrNominative"): proto.TrNominative,

		strings.ToLower("UkNominative"): proto.UkNominative,
		strings.ToLower("UkAccusative"): proto.UkAccusative,

		strings.ToLower("DeNominative"): proto.DeNominative,
	}
	for key, value := range reference.LangCaseMap {
		if value == "" {
			delete(reference.LangCaseMap, key)
		}
	}
	return reference
}
