package context

import (
	"context"
)

type ctxKey struct{}

var (
	jobIDCtxKey           = new(ctxKey)
	contextPropsCtxKey    = new(ctxKey)
	searchPropsCtxKey     = new(ctxKey)
	usePartnerCacheCtxKey = new(ctxKey)
)

func WithPartnerCache(ctx context.Context, flag bool) context.Context {
	return context.WithValue(ctx, &usePartnerCacheCtxKey, flag)
}

func UsePartnerCache(ctx context.Context) (usePartnerCache bool) {
	usePartnerCache, _ = ctx.Value(&usePartnerCacheCtxKey).(bool)
	return
}

func WithJobID(ctx context.Context, jobID string) context.Context {
	return context.WithValue(ctx, &jobIDCtxKey, jobID)
}

func GetJobID(ctx context.Context) (jobID string) {
	jobID, _ = ctx.Value(&jobIDCtxKey).(string)
	return
}

func WithSearchProps(ctx context.Context, searchProps *SearchPropsStore) context.Context {
	return context.WithValue(ctx, &searchPropsCtxKey, searchProps)
}

func GetSearchProps(ctx context.Context) (searchProps *SearchPropsStore) {
	searchProps, _ = ctx.Value(&searchPropsCtxKey).(*SearchPropsStore)
	return
}

func WithWizardContextProps(ctx context.Context, contextProps *PropsStore) context.Context {
	return context.WithValue(ctx, &contextPropsCtxKey, contextProps)
}

func GetWizardContextProps(ctx context.Context) (contextProps *PropsStore) {
	contextProps, _ = ctx.Value(&contextPropsCtxKey).(*PropsStore)
	return
}
