package domain

const (
	SamePoint                    = "same_point"
	NoAirport                    = "no_airport"
	SameAirports                 = "same_airports"
	BadPoint                     = "bad_point"
	NoTranslation                = "no_translation"
	BadFlightNumber              = "bad_flight_number"
	BadFlightPoints              = "bad_flight_points"
	BadFlight                    = "bad_flight"
	BannedFlight                 = "banned_flight"
	InvalidDate                  = "invalid_date"
	NoFlights                    = "no_flights"
	NoFlightVariants             = "no_flight_variants"
	NotImplemented               = "not_implemented"
	NoContent                    = "no_content"
	BadSettlement                = "bad_settlement"
	NoCode                       = "no_code"
	SharedFlightsError           = "shared_flights_error"
	AbsentParameters             = "absent_parameters"
	BadArguments                 = "bad_arguments"
	BadLang                      = "bad_lang"
	BadTld                       = "bad_tld"
	BadNationalVersion           = "bad_national_version"
	Fail                         = "FAIL"
	P2PCompany                   = "p2p_company"
	NoSettlement                 = "no_settlement"
	BadBaggageCode               = "bad_baggage_code"
	YdbBadResponse               = "ydb_bad_response"
	NoDate                       = "no_date"
	YdbStatementExecutionError   = "ydb_statement_execution_error"
	YdbStatementPreparationError = "ydb_statement_preparation_error"
)

type WizardError struct {
	Message string
	Code    string
}

func NewWizardError(message, code string) *WizardError {
	return &WizardError{Message: message, Code: code}
}

func (err *WizardError) Error() string {
	return err.Message
}
