package flights

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/repositories"
)

type FlightNumberNormalizer struct {
	companyRepository repositories.Company
}

func NewFlightNumberNormalizer(companyRepository repositories.Company) *FlightNumberNormalizer {
	return &FlightNumberNormalizer{companyRepository: companyRepository}
}

func (normalizer *FlightNumberNormalizer) Normalize(flightNumberPtr *string, company *models.Company) string {
	if helpers.IsNil(flightNumberPtr) || *flightNumberPtr == "" {
		return ""
	}
	flightNumber := *flightNumberPtr
	flightNumber = strings.ReplaceAll(flightNumber, " ", "")
	flightNumber = strings.ReplaceAll(flightNumber, "-", "")
	flightNumber = strings.ToUpper(flightNumber)

	if helpers.IsDigit(flightNumber) && company != nil {
		code := helpers.AnyString(company.Iata, company.SirenaID)
		if code != "" {
			return fmt.Sprintf("%s %s", code, flightNumber)
		}
	}

	if helpers.IsDigit(flightNumber) {
		return flightNumber
	}

	if len(flightNumber) <= 2 {
		return ""
	}
	runeFlightNumber := []rune(flightNumber)
	code, flightNumber := string(runeFlightNumber[:2]), string(runeFlightNumber[2:])
	if normalizer.companyRepository.GetByCode(code) != nil && helpers.IsDigit(flightNumber) {
		return fmt.Sprintf("%s %s", code, flightNumber)
	}
	return ""
}
