package flights

import (
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type Point struct {
	Timezone      *time.Location
	Airport       *models.Station
	AirportCode   string
	ScheduledTime time.Time
	Time          *time.Time
	Terminal      *string
	Gate          *string
	IsActual      bool
	DataSource    string
}

func (point Point) GetEstimatedTime() time.Time {
	if point.Time == nil {
		return point.ScheduledTime
	}
	return *point.Time
}
