package building

import (
	"math"
	"sort"
	"time"

	flightsModel "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/flights"
)

type (
	Tab struct {
		Date    time.Time
		Flights flightsModel.Flights
	}
	Tabs []Tab
)

func (tab Tab) Len() int      { return len(tab.Flights) }
func (tab Tab) Swap(i, j int) { tab.Flights[i], tab.Flights[j] = tab.Flights[j], tab.Flights[i] }

func (tab Tab) Less(i, j int) bool {
	left := tab.Flights[i].PointFrom.Time
	right := tab.Flights[j].PointFrom.Time

	if left == nil {
		return true
	}
	if right == nil {
		return true
	}
	return left.Before(*right)
}

func (tabs Tabs) Len() int           { return len(tabs) }
func (tabs Tabs) Swap(i, j int)      { tabs[i], tabs[j] = tabs[j], tabs[i] }
func (tabs Tabs) Less(i, j int) bool { return tabs[i].Date.Before(tabs[j].Date) }

func BuildFlightTabs(srcFlights flightsModel.Flights) Tabs {
	tabsMap := make(map[time.Time]flightsModel.Flights)
	for _, flight := range srcFlights {
		tabsMap[flight.PointFrom.ScheduledTime] = append(tabsMap[flight.PointFrom.ScheduledTime], flight)
	}
	tabs := make(Tabs, 0, len(tabsMap))
	for date, tabFlights := range tabsMap {
		tab := Tab{date, tabFlights}
		sort.Stable(tab)

		tabs = append(tabs, tab)
	}

	sort.Stable(tabs)
	return tabs
}

func GetDisplayedTabs(index int, tabs Tabs) Tabs {
	left := int(math.Max(float64(index-1), 0))
	right := int(math.Min(float64(index+3), float64(len(tabs))))
	return tabs[left:right]
}
