package building

import (
	"context"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/handlers/responses"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/landings"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/parameters"
)

type URLBuilder struct {
}

func NewURLBuilder() *URLBuilder {
	return &URLBuilder{}
}

func (builder *URLBuilder) createRedirectURL(
	variant *responses.Variant,
	queryParameters *parameters.QueryParameters,
	landingParameters, offerParams map[string]string,
	landingBuilder *landings.FrontLandingBuilder,
) string {
	redirectLanding := landingBuilder.Redirect(variant).WithParams(landingParameters).WithParams(offerParams)
	if withBaggage, ok := queryParameters.Filters().WithBaggage(); ok && withBaggage != nil && *withBaggage {
		return redirectLanding.WithParam("withBaggage", "1").AsString()
	}
	return redirectLanding.AsString()
}

func (builder *URLBuilder) createOrderURL(
	ctx context.Context,
	variant *responses.Variant,
	queryParameters *parameters.QueryParameters,
	landingParameters, offerParams map[string]string,
	searchResultLanding *landings.Landing,
	from, to *models.Settlement,
	landingBuilder *landings.FrontLandingBuilder,
) string {
	if buttonRedirectToSearchResultPage(ctx, queryParameters) {
		return searchResultLanding.AsString()
	}
	orderLanding := landingBuilder.
		OrderURL(from, to, variant, queryParameters.UseTravelPortal()).
		WithParams(landingParameters).
		WithParams(offerParams)
	if withBaggage, ok := queryParameters.Filters().WithBaggage(); ok && withBaggage != nil && *withBaggage {
		return orderLanding.WithParam("withBaggage", "1").AsString()
	}
	return orderLanding.AsString()
}

func buttonRedirectToSearchResultPage(
	ctx context.Context,
	queryParameters *parameters.QueryParameters,
) bool {
	return needOverrideRedirectURL(ctx, queryParameters) && queryParameters.Flags.ButtonRedirectToSearchResultPage()
}

func buttonRedirectToOrderPage(
	ctx context.Context,
	queryParameters *parameters.QueryParameters,
	searchDepth int,
) bool {
	return needOverrideRedirectURL(ctx, queryParameters) && queryParameters.Flags.ButtonRedirectToOrderPage() ||
		searchDepth >= queryParameters.Flags.SearchDepthButtonRedirectToOrderPage()
}

func snippetRedirectToSearchResultPage(
	ctx context.Context,
	queryParameters *parameters.QueryParameters,
) bool {
	return needOverrideRedirectURL(ctx, queryParameters) && queryParameters.Flags.SnippetRedirectToSearchResultPage()
}
