package building

type WizardType string

const (
	WizardTypeCommon        WizardType = "common"
	WizardTypeCommonAirline WizardType = "common_airline"
	WizardTypePP            WizardType = "pp"
	WizardTypePPAirline     WizardType = "pp_airline"
	WizardTypeFlight        WizardType = "flight"
)

func (wizardType WizardType) String() string {
	return string(wizardType)
}

type WizardSubtype string

const (
	WizardSubtypeExactFlight WizardSubtype = "exact_flight"
	WizardSubtypeQuasiFlight WizardSubtype = "quasi_flight"
)

func (wizardSubtype WizardSubtype) String() string {
	return string(wizardSubtype)
}
