package responses

import "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/flags"

type (
	CommonResponse struct {
		GreenURL           []URL                  `json:"greenurl"`
		Context            map[string]interface{} `json:"context"`
		Title              Title                  `json:"title"`
		Button             URL                    `json:"button"`
		Factors            Factors                `json:"factors"`
		Flags              map[string]string      `json:"flags"`
		From               Point                  `json:"from"`
		Content            CommonContent          `json:"content"`
		Reqid              string                 `json:"reqid"`
		SearchProps        map[string]interface{} `json:"search_props"`
		Type               string                 `json:"type"`
		QueryCompany       *QueryCompany          `json:"query_company"`
		Directions         []interface{}          `json:"directions"`
		Companies          []int                  `json:"companies"`
		Params             map[string]string      `json:"params"`
		AppliedFilters     *AppliedFilters        `json:"applied_filters,omitempty"`
		PrimaryPartnerCode string                 `json:"primary_partner_code,omitempty"`
	}
	QueryCompany struct {
		ID int `json:"id"`
	}
	CommonContent struct {
		Text   string `json:"text"`
		Offers Offers `json:"offers"`
	}
)

func (commonResponse *CommonResponse) SetContext(ctx map[string]interface{}) {
	commonResponse.Context = ctx
}

func (commonResponse *CommonResponse) GetSearchProps() map[string]interface{} {
	return commonResponse.SearchProps
}

func (commonResponse *CommonResponse) SetSearchProps(searchProps map[string]interface{}) {
	commonResponse.SearchProps = searchProps
}

func (commonResponse *CommonResponse) SetFlags(flags flags.Flags) {
	commonResponse.Flags = flags
}

func (commonResponse *CommonResponse) GetAppliedFilters() *AppliedFilters {
	return commonResponse.AppliedFilters
}

func (commonResponse *CommonResponse) GetType() *string {
	if commonResponse == nil {
		return nil
	}
	return &commonResponse.Type
}
