package responses

type (
	Content struct {
		Partners              []*Partner     `json:"partners"`
		Offers                *Offers        `json:"offers"`
		Companies             []*Company     `json:"companies"`
		Version               *int32         `json:"version"`
		PartnersPollingStatus *PollingStatus `json:"partners_polling_status"`
	}

	PollingStatus struct {
		AskedPartners          []*Partner `json:"asked_partners"`
		AskedPartnersCount     *int32     `json:"asked_partners_count"`
		RemainingPartners      []*Partner `json:"remaining_partners"`
		RemainingPartnersCount *int32     `json:"remaining_partners_count"`
	}

	Company struct {
		Logo    string          `json:"logo"`
		Baggage *CompanyBaggage `json:"baggage"`
		ID      int             `json:"id"`
		Title   string          `json:"title"`
	}

	CompanyBaggage struct {
		CostType string `json:"cost_type"`
		Title    string `json:"title"`
	}

	Baggage struct {
		CarryOn *CarryOn `json:"carry_on"`
		Checked Checked  `json:"checked"`
	}

	CarryOn struct {
		Weight        *float64 `json:"weight"`
		DimensionsSum *int     `json:"dimensions_sum"`
		Height        *int     `json:"height"`
		Width         *int     `json:"width"`
		Length        *int     `json:"length"`
		Included      *bool    `json:"included"`
	}

	Dimensions struct {
		Height *int `json:"height"`
		Length *int `json:"length"`
		Sum    *int `json:"sum"`
		Width  *int `json:"width"`
	}

	Checked struct {
		Included   *bool       `json:"included"`
		Dimensions *Dimensions `json:"dimensions"`
		Weight     *int        `json:"weight"`
		Pieces     *int        `json:"pieces"`
	}
)
