package responses

import "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain"

type ErrorResponse struct {
	Message     string                 `json:"error_text"`
	Code        string                 `json:"error"`
	SearchProps map[string]interface{} `json:"search_props,omitempty"`
	Context     map[string]interface{} `json:"context,omitempty"`
}

func NewErrorResponseFromError(err error, searchProps, context map[string]interface{}) *ErrorResponse {
	if e, ok := err.(*domain.WizardError); ok {
		return &ErrorResponse{
			Message:     e.Message,
			Code:        e.Code,
			SearchProps: searchProps,
			Context:     context,
		}
	}
	return NewErrorResponseFromString(err.Error(), searchProps, context)
}

func NewErrorResponse(message, code string) *ErrorResponse {
	return &ErrorResponse{Message: message, Code: code}
}

func NewErrorResponseFromString(message string, searchProps, context map[string]interface{}) *ErrorResponse {
	return &ErrorResponse{Message: message, Code: "unknown", SearchProps: searchProps, Context: context}
}

func (err *ErrorResponse) Error() string {
	return err.Message
}
