package responses

import "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/containers"

type (
	FiltersDefaults struct {
		Transfer    *TransferFilter         `json:"transfer"`
		Airlines    []*AirlineFilter        `json:"airlines"`
		Airport     *AirportFilter          `json:"airport"`
		WithBaggage *bool                   `json:"withBaggage"`
		Time        *TimeFilter             `json:"time"`
		Prices      *Prices                 `json:"prices"`
		AllAirlines *containers.SetOfInt    `json:"all_airlines"`
		Partners    *containers.SetOfString `json:"partners"`
	}

	TransferFilter struct {
		Count            *int     `json:"count"`
		MinDuration      *float32 `json:"minDuration"`
		MaxDuration      *float32 `json:"maxDuration"`
		HasAirportChange *bool    `json:"hasAirportChange"`
		HasNight         *bool    `json:"hasNight"`
	}

	AirlineFilter struct {
		Logo  string `json:"logo"`
		ID    int    `json:"id"`
		Title string `json:"title"`
	}

	AirportFilter struct {
		ForwardDeparture  []*AirportFilterValue `json:"forwardDeparture"`
		ForwardTransfers  []*AirportFilterValue `json:"forwardTransfers"`
		ForwardArrival    []*AirportFilterValue `json:"forwardArrival"`
		BackwardDeparture []*AirportFilterValue `json:"backwardDeparture"`
		BackwardTransfers []*AirportFilterValue `json:"backwardTransfers"`
		BackwardArrival   []*AirportFilterValue `json:"backwardArrival"`
	}

	AirportFilterValue struct {
		ID    int    `json:"id"`
		Title string `json:"title"`
	}

	TimeFilter struct {
		ForwardDepartureMin  *string `json:"forwardDepartureMin"`
		ForwardDepartureMax  *string `json:"forwardDepartureMax"`
		ForwardArrivalMin    *string `json:"forwardArrivalMin"`
		ForwardArrivalMax    *string `json:"forwardArrivalMax"`
		BackwardDepartureMin *string `json:"backwardDepartureMin"`
		BackwardDepartureMax *string `json:"backwardDepartureMax"`
		BackwardArrivalMin   *string `json:"backwardArrivalMin"`
		BackwardArrivalMax   *string `json:"backwardArrivalMax"`
	}

	Prices struct {
		Airports       *AirportsPrices        `json:"airports"`
		DirectAirlines containers.SetOfInt    `json:"directAirlines"`
		Airlines       map[string]*Price      `json:"airlines"`
		WithBaggage    *PriceValue            `json:"withBaggage"`
		DirectFlight   *PriceValue            `json:"directFlight"`
		Transfers      map[string]*PriceValue `json:"transfers"`
	}

	AirportsPrices struct {
		From map[string]*Price `json:"from"`
		To   map[string]*Price `json:"to"`
	}

	Price struct {
		Currency string  `json:"currency"`
		Price    float64 `json:"price"`
	}

	PriceValue struct {
		Currency string  `json:"currency"`
		Value    float64 `json:"value"`
	}
)
