package responses

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/flags"
)

type (
	FlightResponse struct {
		Button         URL                    `json:"button"`
		Content        FlightContent          `json:"content"`
		Context        map[string]interface{} `json:"context"`
		Factors        Factors                `json:"factors"`
		Flags          flags.Flags            `json:"flags"`
		GreenURL       []URL                  `json:"greenurl"`
		Params         map[string]string      `json:"params"`
		ReqID          string                 `json:"reqid"`
		SearchProps    map[string]interface{} `json:"search_props"`
		Title          Title                  `json:"title"`
		Type           string                 `json:"type"`
		Subtype        string                 `json:"subtype"`
		FlightVariants []*FlightVariant       `json:"flight_variants"`
	}

	FlightVariant struct {
		Button      URL           `json:"button"`
		Content     FlightContent `json:"content"`
		Factors     Factors       `json:"factors"`
		GreenURL    []URL         `json:"greenurl"`
		Title       Title         `json:"title"`
		CompanyCode string        `json:"company_code"`
	}

	FlightContent struct {
		Tabs []Tab  `json:"tabs"`
		Text string `json:"text"`
	}

	Tab struct {
		Default bool     `json:"default"`
		Flights []Flight `json:"flights"`
		Title   string   `json:"title"`
	}

	Title struct {
		Text TitleText `json:"text"`
		URL  string    `json:"url"`
	}

	TitleText struct {
		HL string `json:"__hl"`
	}

	Flight struct {
		Arrival    FlightPoint `json:"arrival"`
		Buttons    []URL       `json:"buttons"`
		Departure  FlightPoint `json:"departure"`
		Duration   Duration    `json:"duration"`
		LastUpdate *string     `json:"last_update"`
		Number     string      `json:"number"`
		Status     Status      `json:"status"`
	}

	FlightPoint struct {
		Airport       string  `json:"airport"`
		City          string  `json:"city"`
		Date          string  `json:"date"`
		DateColor     string  `json:"date_color"`
		DataSource    string  `json:"data_source"`
		Iata          string  `json:"iata"`
		FullGate      *string `json:"full_gate"`
		Gate          *string `json:"gate"`
		GateColor     string  `json:"gate_color"`
		ScheduledTime string  `json:"scheduled_time"`
		Terminal      *string `json:"terminal"`
		TerminalColor string  `json:"terminal_color"`
		Time          string  `json:"time"`
		TimeColor     string  `json:"time_color"`
	}

	Status struct {
		Code                  string  `json:"code"`
		BaggageCarousels      *string `json:"baggage_carousels"`
		BaggageCarouselsColor string  `json:"baggage_carousels_color"`
		CheckInDesks          *string `json:"check_in_desks"`
		CheckInDesksColor     string  `json:"check_in_desks_color"`
		DepartsSoon           bool    `json:"departs_soon"`
		Text                  string  `json:"text"`
		TextColor             string  `json:"text_color"`
	}

	Duration struct {
		InAir  *string `json:"in_air"`
		Passed float64 `json:"passed"`
		Total  string  `json:"total"`
	}
)

func (flightResponse *FlightResponse) SetContext(ctx map[string]interface{}) {
	flightResponse.Context = ctx
}

func (flightResponse *FlightResponse) SetSearchProps(searchProps map[string]interface{}) {
	flightResponse.SearchProps = searchProps
}

func (flightResponse *FlightResponse) SetFlags(flags flags.Flags) {
	flightResponse.Flags = flags
}

func (flightResponse *FlightResponse) GetAppliedFilters() *AppliedFilters {
	return nil
}

func (flightResponse *FlightResponse) GetType() *string {
	if flightResponse == nil {
		return nil
	}
	return &flightResponse.Type
}

func (flightResponse *FlightResponse) GetSearchProps() map[string]interface{} {
	return flightResponse.SearchProps
}
