package responses

import "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"

type (
	Offers struct {
		Cut           int          `json:"cut"`
		Show          int          `json:"show"`
		DepartureDate string       `json:"departure_date"`
		TitleTariff   *TitleTariff `json:"title_tariff"`
		Variants      []*Variant   `json:"variants"`
		Total         int          `json:"total"`
		ReturnDate    *string      `json:"return_date"`
		Sideblock     *int         `json:"sideblock,omitempty"`
	}

	Variant struct {
		ShowID               string             `json:"show_id"`
		OrderURL             string             `json:"order_url"`
		URL                  string             `json:"url"`
		Snippet              string             `json:"snippet"`
		Button               string             `json:"button"`
		PartnerCode          string             `json:"partner_code"`
		Tariff               Tariff             `json:"tariff"`
		Popularity           int32              `json:"popularity"`
		BaggageInfo          string             `json:"baggage_info"`
		Baggage              *Baggage           `json:"baggage"`
		Forward              *Trip              `json:"forward"`
		Backward             *Trip              `json:"backward"`
		Type                 *VariantType       `json:"type"`
		OfferFromAviacompany bool               `json:"offer_from_aviacompany"`
		Qid                  string             `json:"-"`
		BaggageType          models.BaggageType `json:"-"`
		CreatedAt            int32              `json:"-"`
	}

	TitleTariff struct {
		Currency string  `json:"currency"`
		Price    float64 `json:"price"`
	}

	Tariff struct {
		Currency string  `json:"currency"`
		Price    float64 `json:"price"`
	}

	TariffValue struct {
		Currency string  `json:"currency"`
		Value    float64 `json:"value"`
	}

	Settlement struct {
		Code          string  `json:"code"`
		TitleLocative *string `json:"title_locative"`
		Title         string  `json:"title"`
	}

	Station struct {
		PointKey      string  `json:"-"`
		IATA          string  `json:"-"`
		Code          string  `json:"code"`
		TitleLocative *string `json:"title_locative"`
		Title         string  `json:"title"`
	}

	RoutePoint struct {
		Settlement Settlement `json:"settlement"`
		Station    Station    `json:"station"`
	}

	Trip struct {
		Duration    int         `json:"duration"`
		Flights     []*PPFlight `json:"flights"`
		RedirectKey string      `json:"-"`
	}

	PPFlight struct {
		Arrival   *RoutePoint `json:"arrival"`
		Number    string      `json:"number"`
		CompanyID int         `json:"company_id"`
		Departure *RoutePoint `json:"departure"`
		ArrivesAt string      `json:"arrives_at"`
		DepartsAt string      `json:"departs_at"`
		Stopover  *Stopover   `json:"stopover,omitempty"`
	}

	Stopover struct {
		Duration      int  `json:"duration"`
		AirportChange bool `json:"airport_change"`
		Overnight     bool `json:"overnight"`
	}

	VariantType struct {
		TextFeatures []*string `json:"text_features"`
		Text         *string   `json:"text"`
		Code         string    `json:"code"`
		Codes        []string  `json:"codes"`
	}
)
