package responses

import "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/flags"

type (
	PointToPointResponse struct {
		WizardType         string                 `json:"wizard_type"`
		GreenURL           []URL                  `json:"greenurl"`
		Context            map[string]interface{} `json:"context"`
		Title              TitlePP                `json:"title"`
		Button             URL                    `json:"button"`
		Factors            Factors                `json:"factors"`
		Flags              map[string]string      `json:"flags"`
		Content            Content                `json:"content"`
		To                 Point                  `json:"to"`
		From               Point                  `json:"from"`
		Reqid              string                 `json:"reqid"`
		AppliedFilters     *AppliedFilters        `json:"applied_filters"`
		Params             map[string]interface{} `json:"params"`
		CounterPrefix      string                 `json:"counter_prefix"`
		SearchProps        map[string]interface{} `json:"search_props"`
		Type               string                 `json:"type"`
		FiltersDefaults    *FiltersDefaults       `json:"filters_defaults"`
		PrimaryPartnerCode string                 `json:"primary_partner_code,omitempty"`
	}

	TitlePP struct {
		URL              string `json:"url"`
		Text             Text   `json:"text"`
		TitleDescription string `json:"title_description"`
	}

	Airports struct {
		To   RoutePoint `json:"to"`
		From RoutePoint `json:"from"`
	}

	Context struct {
		SerpUUID    string `json:"serp_uuid"`
		UtmMedium   string `json:"utm_medium"`
		UtmSource   string `json:"utm_source"`
		UtmCampaign string `json:"utm_campaign"`
	}

	Text struct {
		Hl string `json:"__hl"`
	}

	Factors struct {
		Distance            *float64 `json:"distance,omitempty"`
		OffersReturned      *int     `json:"offers_returned,omitempty"`
		TypePp              *int     `json:"type_pp,omitempty"`
		DirectionPopularity *int     `json:"direction_popularity,omitempty"`
		FlightCount         *int     `json:"flight_count,omitempty"`
		OffersTotal         *int     `json:"offers_total,omitempty"`
		MinPrice            *int     `json:"min_price,omitempty"`
		VariantsShown       *int     `json:"variants_shown,omitempty"`
		TypeFlight          *int     `json:"type_flight,omitempty"`
		TypeCommonAirline   *int     `json:"type_common_airline,omitempty"`
		TypeCommon          *int     `json:"type_common,omitempty"`
		Airline             *int     `json:"airline,omitempty"`
		MinForwardSegments  *int     `json:"min_forward_segments,omitempty"`
		MinBackwardSegments *int     `json:"min_backward_segments,omitempty"`
		MinForwardDuration  *int     `json:"min_forward_duration,omitempty"`
		MinBackwardDuration *int     `json:"min_backward_duration,omitempty"`
	}

	Point struct {
		PointKey string `json:"point_key"`
		ID       int    `json:"id"`
		Title    string `json:"title"`
	}

	Passengers struct {
		Adults   int `json:"adults"`
		Children int `json:"children"`
		Infants  int `json:"infants"`
	}

	Partner struct {
		Code  string `json:"code"`
		Title string `json:"title"`
		URL   string `json:"url"`
		Icon  string `json:"icon"`
	}
)

func (ppResponse *PointToPointResponse) SetContext(ctx map[string]interface{}) {
	ppResponse.Context = ctx
}

func (ppResponse *PointToPointResponse) SetSearchProps(searchProps map[string]interface{}) {
	ppResponse.SearchProps = searchProps
}

func (ppResponse *PointToPointResponse) SetFlags(flags flags.Flags) {
	ppResponse.Flags = flags
}

func (ppResponse *PointToPointResponse) GetAppliedFilters() *AppliedFilters {
	return ppResponse.AppliedFilters
}

func (ppResponse *PointToPointResponse) GetType() *string {
	if ppResponse == nil {
		return nil
	}
	return &ppResponse.Type
}

func (ppResponse *PointToPointResponse) GetSearchProps() map[string]interface{} {
	return ppResponse.SearchProps
}
