package models

type BaggageType string

var (
	BaggageTypeNormal  BaggageType = "normal"
	BaggageTypeLowcost BaggageType = "lowcost"
	BaggageTypeHybrid  BaggageType = "hybrid"
)

func (variantType BaggageType) String() string {
	return string(variantType)
}

type CheckedBaggage struct {
	Included *int
	Pieces   *int
	Weight   *int
}
