package models

type PointType int

const (
	PointTypeStation PointType = iota
	PointTypeSettlement
	PointTypeRegion
	PointTypeCountry
)

type Point interface {
	GetPointType() PointType
	GetPointKey() string
	GetTitleID() int
	GetID() int
}

type SetOfPoints map[Point]struct{}

func (set SetOfPoints) Add(value Point) {
	set[value] = struct{}{}
}

func (set SetOfPoints) IsSubset(other SetOfPoints) bool {
	for key := range set {
		if _, found := other[key]; !found {
			return false
		}
	}
	return true
}
