package models

import "fmt"

type Settlement struct {
	ID                      int
	GeoID                   int
	CountryID               int
	RegionID                int
	IataCode                string
	SirenaID                string
	Address                 string
	Title                   string
	Longitude               float64
	Latitude                float64
	MajorityID              int
	NewLTitleID             int
	Hidden                  bool
	TimeZone                string
	TitleRuPrepositionVVoNa string
}

func (m *Settlement) GetID() int {
	return m.ID
}

func (m *Settlement) GetIata() string {
	return m.IataCode
}

func (m *Settlement) GetTitleID() int {
	return m.NewLTitleID
}

func (m *Settlement) GetPointType() PointType {
	return PointTypeSettlement
}

func (m *Settlement) GetPointKey() string {
	return fmt.Sprintf("%s%d", "c", m.ID)
}
