package models

import "fmt"

type StationType int

var (
	AirportID StationType = 9
)

type Station struct {
	ID                      int
	MajorityID              int
	SettlementID            int
	TTypeID                 int
	Hidden                  bool
	RegionID                int
	CountryID               int
	TimeZone                string
	Title                   string
	NewLTitleID             int
	StationTypeID           int
	TitleRuPrepositionVVoNa string
}

func (m *Station) GetID() int {
	return m.ID
}

func (m *Station) GetTitleID() int {
	return m.NewLTitleID
}

func (m *Station) WithSettlement() bool {
	return m.SettlementID != 0
}

func (m *Station) IsAirport() bool {
	return m.StationTypeID == int(AirportID) && !m.Hidden
}

func (m *Station) GetPointType() PointType {
	return PointTypeStation
}

func (m *Station) GetPointKey() string {
	return fmt.Sprintf("%s%d", "s", m.ID)
}
