package models

import (
	"fmt"
)

type TranslatedTitle struct {
	ID           int
	RuNominative string
	RuGenitive   string
	RuDative     string
	RuAccusative string
	RuLocative   string
	EnNominative string
	TrNominative string
	UkNominative string
	UkAccusative string
	DeNominative string
	LangCaseMap  map[string]string
}

func (title *TranslatedTitle) GetTranslation(lang Lang, grammaticalCase GrammaticalCase) (string, error) {
	if translatedTitle, ok := title.LangCaseMap[lang.String()+grammaticalCase.String()]; ok {
		return translatedTitle, nil
	}
	return "", fmt.Errorf("no translation for the lang %s and grammatical case %s", lang, grammaticalCase)
}
