package checkers

import (
	"net/http"
	"strings"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain"
)

func checkNecessaryParametersProvided(request *http.Request, requiredParams []string) error {
	query := request.URL.Query()
	var absentParameters = make([]string, 0, len(requiredParams))

	for _, parameter := range requiredParams {
		if query.Get(parameter) == "" {
			absentParameters = append(absentParameters, parameter)
		}
	}

	if len(absentParameters) > 0 {
		var errorMessage = "Parameters are absent: " + strings.Join(absentParameters, ", ")
		return domain.NewWizardError(errorMessage, domain.AbsentParameters)
	}
	return nil
}
