package checkers

import (
	"net/http"
)

var (
	mandatoryWizardParameters = []string{
		"main_reqid",
		"reqid",
		"user_request",
		"geo_id",
		"lang",
		"tld",
	}
)

type WizardChecker struct{}

func (checker WizardChecker) CheckParameters(request *http.Request) error {
	return checkNecessaryParametersProvided(request, mandatoryWizardParameters)
}

func NewWizardChecker() *WizardChecker {
	return &WizardChecker{}
}
