package dynamic

import (
	"encoding/json"
)

type IAviaDynamicParser interface {
	Parse(rawInput string) (*AviaDynamic, error)
}

type AviaDynamicParser struct {
}

func (p *AviaDynamicParser) Parse(rawInput string) (*AviaDynamic, error) {
	if len(rawInput) == 0 {
		return nil, nil
	}

	aviaDynamic := AviaDynamic{}
	err := json.Unmarshal([]byte(rawInput), &aviaDynamic)
	if err != nil {
		return nil, err
	}
	if aviaDynamic.Passengers.ToUInt32() == 0 {
		aviaDynamic.Passengers = Passengers{Adults: 1}
	}

	return &aviaDynamic, nil
}

func NewAviaDynamicParser() *AviaDynamicParser {
	return &AviaDynamicParser{}
}
