package dynamic

import (
	"reflect"

	"a.yandex-team.ru/library/go/ptr"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
)

type Context map[string]interface{}

func (context Context) Equals(otherContext Context) bool {
	return reflect.DeepEqual(context, otherContext)
}

func (context Context) getField(fieldName string) (interface{}, bool) {
	if helpers.IsNil(context) {
		return nil, false
	}
	val, ok := context[fieldName]
	if helpers.IsNil(val) {
		return nil, ok
	}
	return val, ok
}

func (context Context) getStringField(fieldName string) (*string, bool) {
	val, ok := context.getField(fieldName)
	if !helpers.IsNil(val) {
		return ptr.String(val.(string)), ok
	}
	return nil, ok
}

func (context Context) getBoolField(fieldName string) (*bool, bool) {
	val, ok := context.getField(fieldName)
	if !helpers.IsNil(val) {
		return ptr.Bool(val.(bool)), ok
	}
	return nil, ok
}

func (context Context) getIntField(fieldName string) (*int, bool) {
	val, ok := context.getField(fieldName)
	if !helpers.IsNil(val) {
		return ptr.Int(int(val.(float64))), ok
	}
	return nil, ok
}

func (context Context) getIntFieldOrDefault(fieldName string, defaultValue int) int {
	result := defaultValue

	val, ok := context.getField(fieldName)
	if !ok || helpers.IsNil(val) {
		return result
	}
	if f, ok := val.(float64); ok {
		result = int(f)
	}
	return result
}

func (context Context) UtmCampaign() (*string, bool) {
	return context.getStringField("utm_campaign")
}

func (context Context) SerpUUID() (*string, bool) {
	return context.getStringField("serp_uuid")
}

func (context Context) UtmSource() (*string, bool) {
	return context.getStringField("utm_source")
}

func (context Context) UtmMedium() (*string, bool) {
	return context.getStringField("utm_medium")
}

func (context Context) Company() (*int, bool) {
	return context.getIntField("company")
}

func (context Context) DirectFlight() (*bool, bool) {
	return context.getBoolField("direct_flight")
}

func (context Context) OffersUnderCut() int {
	return context.getIntFieldOrDefault("offers_under_cut", 10)
}

func (context Context) OffersToShow() int {
	return context.getIntFieldOrDefault("offers_to_show", 5)
}
