package dynamic

import (
	"a.yandex-team.ru/library/go/ptr"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/containers"
)

type (
	Filters        map[string]interface{}
	TransferFilter map[string]interface{}
	AirportFilter  struct {
		ForwardDeparutre  containers.SetOfInt
		ForwardArrival    containers.SetOfInt
		ForwardTransfers  containers.SetOfInt
		BackwardDeparutre containers.SetOfInt
		BackwardArrival   containers.SetOfInt
		BackwardTransfers containers.SetOfInt
	}
)

func (filters Filters) Empty() bool {
	if len(filters) == 0 {
		return true
	}

	airlinesFilter, _ := filters.Airlines()
	partnersFilter, _ := filters.Partners()
	transferFilter, _ := filters.Transfer()
	withBaggageFilter, _ := filters.WithBaggage()
	return airlinesFilter == nil && partnersFilter == nil && transferFilter == nil && withBaggageFilter == nil
}

func (filters Filters) Airlines() (containers.SetOfInt, bool) {
	if helpers.IsNil(filters) {
		return nil, false
	}
	if val, ok := filters["airlines"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		set := containers.NewSetOfInt()
		switch airlines := val.(type) {
		case []interface{}:
			for _, airlineID := range airlines {
				set.Add(int(airlineID.(float64)))
			}
		case containers.SetOfInt:
			return airlines, true
		case nil:
			return nil, ok
		}
		return set, ok
	}
	return nil, false
}

func (filters Filters) Partners() (containers.SetOfString, bool) {
	if helpers.IsNil(filters) {
		return nil, false
	}
	if val, ok := filters["partners"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		set := containers.NewSetOfString()
		switch partners := val.(type) {
		case []interface{}:
			for _, partnerCode := range partners {
				set.Add(partnerCode.(string))
			}
		case containers.SetOfString:
			return partners, true
		case nil:
			return nil, ok
		}
		return set, ok
	}
	return nil, false
}

func (filters Filters) WithBaggage() (*bool, bool) {
	if helpers.IsNil(filters) {
		return nil, false
	}
	if val, ok := filters["withBaggage"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return ptr.Bool(val.(bool)), ok
	}
	return nil, false
}

func (filters Filters) Transfer() (TransferFilter, bool) {
	if helpers.IsNil(filters) {
		return nil, false
	}
	if val, ok := filters["transfer"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return val.(map[string]interface{}), ok
	}
	return nil, false
}

func (transferFilter TransferFilter) Count() (*int, bool) {
	if helpers.IsNil(transferFilter) {
		return nil, false
	}
	if val, ok := transferFilter["count"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return ptr.Int(int(val.(float64))), ok
	}
	return nil, false
}

func (transferFilter TransferFilter) HasAirportChange() (*bool, bool) {
	if helpers.IsNil(transferFilter) {
		return nil, false
	}
	if val, ok := transferFilter["hasAirportChange"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return ptr.Bool(val.(bool)), ok
	}
	return nil, false
}

func (transferFilter TransferFilter) HasNight() (*bool, bool) {
	if helpers.IsNil(transferFilter) {
		return nil, false
	}
	if val, ok := transferFilter["hasNight"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return ptr.Bool(val.(bool)), ok
	}
	return nil, false
}

func (transferFilter TransferFilter) MinDuration() (*int, bool) {
	if helpers.IsNil(transferFilter) {
		return nil, false
	}
	if val, ok := transferFilter["minDuration"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return ptr.Int(int(val.(float64))), ok
	}
	return nil, false
}

func (transferFilter TransferFilter) MaxDuration() (*int, bool) {
	if helpers.IsNil(transferFilter) {
		return nil, false
	}
	if val, ok := transferFilter["maxDuration"]; ok {
		if helpers.IsNil(val) {
			return nil, ok
		}
		return ptr.Int(int(val.(float64))), ok
	}
	return nil, false
}
