package dynamic

import (
	"encoding/json"
	"fmt"
	"strconv"
	"strings"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
)

type Passengers struct {
	Adults   int `json:"adults"`
	Children int `json:"children"`
	Infants  int `json:"infants"`
}

func (passengers Passengers) ToUInt32() uint32 {
	return uint32(passengers.Adults*100 + passengers.Children*10 + passengers.Infants)
}

func (passengers Passengers) ToString() string {
	return fmt.Sprintf("%d,%d,%d", passengers.Adults, passengers.Children, passengers.Infants)
}

func (passengers *Passengers) UnmarshalJSON(b []byte) error {
	var passengersString string
	_ = json.Unmarshal(b, &passengersString)
	if passengersString == "" {
		*passengers = Passengers{Adults: 1}
		return nil
	}
	parts := strings.Split(passengersString, ",")
	if len(parts) < 3 || !helpers.IsDigit(parts[0]) || !helpers.IsDigit(parts[1]) || !helpers.IsDigit(parts[2]) {
		return domain.NewWizardError(
			fmt.Sprintf("avia_dynamic parsing error: bad passangers parameter format: %s", passengersString),
			domain.BadArguments,
		)
	}
	adults, _ := strconv.Atoi(parts[0])
	children, _ := strconv.Atoi(parts[1])
	infants, _ := strconv.Atoi(parts[2])
	*passengers = Passengers{
		Adults:   adults,
		Children: children,
		Infants:  infants,
	}
	return nil
}
