package providers

import (
	"strconv"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/helpers"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/repositories"
)

type PointByPointKeyProvider struct {
	countryRepo    repositories.Country
	settlementRepo repositories.Settlement
	regionRepo     repositories.Region
	stationRepo    repositories.Station
}

func NewPointByPointKey(
	countryRepo repositories.Country,
	settlementRepo repositories.Settlement,
	regionRepo repositories.Region,
	stationRepo repositories.Station,
) *PointByPointKeyProvider {
	return &PointByPointKeyProvider{
		countryRepo:    countryRepo,
		settlementRepo: settlementRepo,
		regionRepo:     regionRepo,
		stationRepo:    stationRepo,
	}
}

func (provider *PointByPointKeyProvider) Get(pointKey *string) models.Point {
	if helpers.IsNil(pointKey) || *pointKey == "" {
		return nil
	}
	typePrefix, key := (*pointKey)[0], (*pointKey)[1:]
	intKey, err := strconv.Atoi(key)
	if err != nil {
		return nil
	}
	switch typePrefix {
	case 'c':
		point, _ := provider.settlementRepo.GetByID(intKey)
		return point
	case 's':
		point, _ := provider.stationRepo.GetByID(intKey)
		return point
	case 'l':
		point, _ := provider.countryRepo.GetByID(intKey)
		return point
	case 'r':
		point, _ := provider.regionRepo.GetByID(intKey)
		return point
	}
	return nil
}
