package providers

import (
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/point/finder"
)

type PointByTitleProvider struct {
	finder *finder.Finder
}

func NewPointByTitleProvider(finder *finder.Finder) *PointByTitleProvider {
	return &PointByTitleProvider{finder: finder}
}

func (provider *PointByTitleProvider) Get(title string) models.Point {
	if point := provider.finder.FindCountry(title, true); point != nil {
		return point
	}

	if point := provider.finder.FindSettlement(title); point != nil {
		return point
	}

	if point := provider.finder.FindStation(title); point != nil {
		return point
	}

	if point := provider.finder.FindCountry(title, false); point != nil {
		return point
	}

	if point := provider.finder.FindRegion(title); point != nil {
		return point
	}
	return nil
}

func (provider *PointByTitleProvider) FindRegion(title string) models.Point {
	return provider.finder.FindRegion(title)
}
