package results

import (
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
)

type (
	Fare struct {
		ForwardTrip     Trip
		BackwardTrip    Trip
		PartnerCode     string
		Tariff          Tariff
		Qid             string
		FromAviaCompany bool
		ExpiresAt       int32
		CreatedAt       int32
		Popularity      int32
		Baggage         *Baggage
		IsPromo         bool
	}

	Baggage struct {
		CarryOn *CarryOn `json:"carry_on"`
		Checked *Checked `json:"checked"`
	}

	CarryOn struct {
		Weight        *float64 `json:"weight"`
		DimensionsSum *int     `json:"dimensions_sum"`
		Height        *int     `json:"height"`
		Width         *int     `json:"width"`
		Length        *int     `json:"length"`
		Included      *bool    `json:"included"`
	}

	Dimensions struct {
		Height *int `json:"height"`
		Length *int `json:"length"`
		Sum    *int `json:"sum"`
		Width  *int `json:"width"`
	}

	Checked struct {
		Included   *bool       `json:"included"`
		Dimensions *Dimensions `json:"dimensions"`
		Weight     *int        `json:"weight"`
		Pieces     *int        `json:"pieces"`
	}

	Segment struct {
		Number      string
		Departure   time.Time
		Arrival     time.Time
		CompanyID   int
		StationFrom *models.Station
		StationTo   *models.Station
	}

	Fares []*Fare

	AirportChange struct {
		AirportFromID int
		AirportToID   int
		SettlementID  int
	}
)

func (dimensions *Dimensions) Merge(aviaCompany *models.AviaCompany) *Dimensions {
	dimensions.Height = minWithPossibleNil(dimensions.Height, aviaCompany.BaggageHeight)
	dimensions.Length = minWithPossibleNil(dimensions.Length, aviaCompany.BaggageLength)
	dimensions.Width = minWithPossibleNil(dimensions.Width, aviaCompany.BaggageWidth)
	dimensions.Sum = minWithPossibleNil(dimensions.Sum, &aviaCompany.BaggageDimensionsSum)
	return dimensions
}

func minWithPossibleNil(a, b *int) *int {
	if a == nil {
		return b
	}
	if b == nil {
		return a
	}
	if *a < *b {
		return a
	}
	return b
}
