package results

import (
	"context"
	"fmt"
	"runtime"

	"github.com/opentracing/opentracing-go"

	wizardProto "a.yandex-team.ru/travel/proto/avia/wizard"
)

type FareGenerator struct {
	currentIndex    int
	faresProto      []*wizardProto.Fare
	flightProtos    map[string]*wizardProto.Flight
	qid             string
	withBaggage     bool
	mapper          FareMapper
	isGoodFareProto func(*wizardProto.Fare, int) bool
}

type FareMapper func(
	fareProto *wizardProto.Fare,
	flightProtos map[string]*wizardProto.Flight,
	qid string,
	withBaggage bool,
) (*Fare, error)

var EmptyFareGenerator = &FareGenerator{
	currentIndex:    0,
	faresProto:      nil,
	flightProtos:    nil,
	qid:             "",
	withBaggage:     false,
	mapper:          nil,
	isGoodFareProto: nil,
}

func NewFareGenerator(
	faresProto []*wizardProto.Fare,
	flightProtos map[string]*wizardProto.Flight,
	qid string,
	withBaggage bool,
	mapper FareMapper,
	isGoodFareProto func(*wizardProto.Fare, int) bool,
) *FareGenerator {
	return &FareGenerator{
		faresProto:      faresProto,
		flightProtos:    flightProtos,
		qid:             qid,
		withBaggage:     withBaggage,
		mapper:          mapper,
		isGoodFareProto: isGoodFareProto,
	}
}

func (fareGenerator *FareGenerator) hasNext() bool {
	return len(fareGenerator.faresProto) > 0 && fareGenerator.currentIndex < len(fareGenerator.faresProto)
}

func (fareGenerator *FareGenerator) Next(ctx context.Context) (*Fare, error) {
	runtime.Gosched()

	span, _ := opentracing.StartSpanFromContext(ctx, "Generation of next fare")
	defer span.Finish()
	for fareGenerator.hasNext() {
		if !fareGenerator.isGoodFareProto(fareGenerator.faresProto[fareGenerator.currentIndex], fareGenerator.currentIndex) {
			fareGenerator.currentIndex++
			continue
		}
		if fare, err := fareGenerator.mapper(
			fareGenerator.faresProto[fareGenerator.currentIndex],
			fareGenerator.flightProtos,
			fareGenerator.qid,
			fareGenerator.withBaggage,
		); err == nil {
			span.SetTag("index", fareGenerator.currentIndex)
			fareGenerator.currentIndex++
			return fare, nil
		}
		fareGenerator.currentIndex++
	}
	return nil, fmt.Errorf("there are no more fares")
}
