package results

import (
	"encoding/json"
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/containers"
)

type Price struct {
	Currency string
	Value    float64
}

type Time time.Time

func (t *Time) UnmarshalJSON(b []byte) error {
	var strTime string
	_ = json.Unmarshal(b, &strTime)
	parsed, err := time.Parse("2006-01-02T15:04:05", strTime)
	if err != nil {
		return err
	}
	*t = Time(parsed)
	return err
}

type FilterState struct {
	Prices *struct {
		WithBaggage  *Price
		DirectFlight *Price
		Airports     *struct {
			From map[string]*Price
			To   map[string]*Price
		}
		Airlines       *map[string]*Price
		DirectAirlines containers.SetOfInt
		Transfers      *map[string]*Price
	}

	Transfer *struct {
		Count            *int
		MinDuration      *float32
		MaxDuration      *float32
		HasAirportChange *bool
		HasNight         *bool
	}

	Time *struct {
		ForwardDepartureMin  *string
		ForwardDepartureMax  *string
		ForwardArrivalMin    *string
		ForwardArrivalMax    *string
		BackwardDepartureMin *string
		BackwardDepartureMax *string
		BackwardArrivalMin   *string
		BackwardArrivalMax   *string
	}

	Airport *struct {
		ForwardDeparture  containers.SetOfInt
		ForwardArrival    containers.SetOfInt
		ForwardTransfers  containers.SetOfInt
		BackwardDeparture containers.SetOfInt
		BackwardArrival   containers.SetOfInt
		BackwardTransfers containers.SetOfInt
	}

	Airlines       *containers.SetOfInt
	DirectAirlines *containers.SetOfInt
	AllAirlines    *containers.SetOfInt `json:"all_airlines"`
	WithBaggage    *bool
	Partners       *containers.SetOfString
}
