package results

import (
	wizardProto "a.yandex-team.ru/travel/proto/avia/wizard"
)

type Flight struct {
	Key           *string
	Arrival       *LocalTimestamp
	Departure     *LocalTimestamp
	ToID          *int32
	FromID        *int32
	CompanyTariff *int32
	Company       *int32
	AviaCompany   *int32
	Number        *string
}

func NewFlightFromProto(flightProto *wizardProto.Flight) *Flight {
	if flightProto == nil {
		return nil
	}
	return &Flight{
		Key:           flightProto.Key,
		Arrival:       NewLocalTimestampFromProto(flightProto.Arrival),
		Departure:     NewLocalTimestampFromProto(flightProto.Departure),
		ToID:          flightProto.ToId,
		FromID:        flightProto.FromId,
		CompanyTariff: flightProto.CompanyTariff,
		Company:       flightProto.Company,
		AviaCompany:   flightProto.AviaCompany,
		Number:        flightProto.Number,
	}
}

type LocalTimestamp struct {
	Local  string
	Tzname string
}

func NewLocalTimestampFromProto(timestampProto *wizardProto.LocalTimestamp) *LocalTimestamp {
	if timestampProto == nil {
		return nil
	}

	return &LocalTimestamp{
		Local:  *timestampProto.Local,
		Tzname: *timestampProto.Tzname,
	}
}

type Flights map[string]*Flight

func NewFlightsFromProto(flightsProto map[string]*wizardProto.Flight) Flights {
	if flightsProto == nil {
		return nil
	}
	flights := make(map[string]*Flight, len(flightsProto))
	for k, v := range flightsProto {
		flights[k] = NewFlightFromProto(v)
	}
	return flights
}
