package results

import wizardProto "a.yandex-team.ru/travel/proto/avia/wizard"

type PollingStatus struct {
	AskedPartners          []string
	AskedPartnersCount     *int32
	RemainingPartners      []string
	RemainingPartnersCount *int32
}

func NewPollingStatusFromProto(pollingStatusProto *wizardProto.PollingStatus) *PollingStatus {
	if pollingStatusProto == nil {
		return nil
	}
	return &PollingStatus{
		AskedPartners:          pollingStatusProto.AskedPartners,
		AskedPartnersCount:     pollingStatusProto.AskedPartnersCount,
		RemainingPartners:      pollingStatusProto.RemainingPartners,
		RemainingPartnersCount: pollingStatusProto.RemainingPartnersCount,
	}
}
