package results

import (
	"math"
	"strings"
	"time"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/lib/containers"
)

type Trip []*Segment

func (trip Trip) DepartureTime() time.Time {
	return trip[0].Departure
}

func (trip Trip) Duration() time.Duration {
	if len(trip) == 0 {
		return 0
	}
	return trip[len(trip)-1].Arrival.Sub((trip)[0].Departure)
}

func (trip Trip) TransfersCount() int {
	return int(math.Max(0, float64(len(trip)-1)))
}

func (trip Trip) BuildRedirectKey() string {
	flightKeyBuilder := strings.Builder{}
	flightKeys := make([]string, 0, len(trip))

	for _, segment := range trip {
		flightKeyBuilder.WriteString(segment.Number)
		flightKeyBuilder.WriteRune('.')
		flightKeyBuilder.WriteString(segment.Departure.Format("2006-01-02T15:04"))
		flightKeys = append(flightKeys, flightKeyBuilder.String())
		flightKeyBuilder.Reset()
	}
	return strings.Join(flightKeys, ",")
}

func (trip Trip) GetAllAirlines() containers.SetOfInt {
	allAirlines := containers.SetOfInt{}
	for _, t := range trip {
		allAirlines.Add(t.CompanyID)
	}
	return allAirlines
}
