package handlers

import (
	"net/http"

	"a.yandex-team.ru/travel/avia/library/go/utils"
)

type EmptyOrganicHandlerResponse struct {
	ErrorText string `json:"error_text"`
	Error     string `json:"error"`
}

type EmptyOrganicHandler struct{}

func (handler EmptyOrganicHandler) ServeHTTP(writer http.ResponseWriter, _ *http.Request) {
	utils.HTTP.JSON(writer, http.StatusOK, EmptyOrganicHandlerResponse{
		ErrorText: "organic cache is empty",
		Error:     "unknown",
	})
}
