package handlers

import (
	"context"
	"encoding/json"
	"net/http"

	"a.yandex-team.ru/library/go/httputil/headers"
)

type PingHandler struct {
	aliveContext context.Context
}

type pingResponse struct {
	Status string `json:"status"`
}

var okResponse, _ = json.Marshal(pingResponse{"OK"})
var badResponse, _ = json.Marshal(pingResponse{"BAD"})

func (h *PingHandler) ServeHTTP(writer http.ResponseWriter, request *http.Request) {
	select {
	case <-h.aliveContext.Done():
		writer.Header().Set(headers.ContentTypeKey, headers.TypeApplicationJSON.String())
		writer.WriteHeader(http.StatusGone)
		_, _ = writer.Write(badResponse)
	default:
		writer.Header().Set(headers.ContentTypeKey, headers.TypeApplicationJSON.String())
		writer.WriteHeader(http.StatusOK)
		_, _ = writer.Write(okResponse)
	}
}

func (h *PingHandler) GetRoute() string {
	return "/ping"
}

func NewPingHandler(ctx context.Context) *PingHandler {
	return &PingHandler{aliveContext: ctx}
}
