package helpers

import (
	"runtime"
	"strconv"
	"strings"
)

func PanicIfNotNil(err error) {
	if err != nil {
		panic(err)
	}
}

func GetTraceback() string {
	const CallersLimit = 10
	pc := make([]uintptr, CallersLimit)
	n := runtime.Callers(3, pc)
	pc = pc[:n]
	i := 0
	frames := runtime.CallersFrames(pc)
	stackTrace := strings.Builder{}
	for frame, more := frames.Next(); more; frame, more = frames.Next() {
		if i != 0 {
			stackTrace.WriteByte('\n')
		}
		i++
		stackTrace.WriteString(frame.Function)
		stackTrace.WriteByte('\n')
		stackTrace.WriteByte('\t')
		stackTrace.WriteString(frame.File)
		stackTrace.WriteByte(':')
		stackTrace.WriteString(strconv.Itoa(frame.Line))
	}
	return stackTrace.String()
}
