package helpers

import (
	"github.com/gofrs/uuid"
)

type JobIDGenerator interface {
	Generate() string
}

type UUIDV4Generator struct{}

func (j *UUIDV4Generator) Generate() string {
	u, _ := uuid.NewV4()
	return u.String()
}

func NewJobIDGenerator() JobIDGenerator {
	return &UUIDV4Generator{}
}
