package props

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	wizardContext "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/context"
)

func WithContextProps(ctx context.Context, logger log.Logger) context.Context {
	store := wizardContext.NewPropsStore(
		make(map[string]interface{}),
		logger,
	)
	return wizardContext.WithWizardContextProps(ctx, store)

}

func SetContextProp(ctx context.Context, key string, value interface{}) {
	store := wizardContext.GetWizardContextProps(ctx)
	store.Set(key, value)
}

func ContextPropsGetAll(ctx context.Context) map[string]interface{} {
	return wizardContext.GetWizardContextProps(ctx).GetAll()
}
