package props

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	wizardContext "a.yandex-team.ru/travel/avia/wizard/pkg/wizard/context"
)

func WithSearchPropsStore(ctx context.Context, logger log.Logger) context.Context {
	store := &wizardContext.SearchPropsStore{PropsStore: *wizardContext.NewPropsStore(
		make(map[string]interface{}),
		logger,
	)}
	return wizardContext.WithSearchProps(ctx, store)
}

func SetSearchProp(ctx context.Context, key string, value interface{}) {
	wizardContext.GetSearchProps(ctx).Set(key, value)
}

func SearchPropsGetAll(ctx context.Context) map[string]interface{} {
	return wizardContext.GetSearchProps(ctx).GetAll()
}

func SearchPropsContains(ctx context.Context, key string) bool {
	return wizardContext.GetSearchProps(ctx).Contains(key)
}

func SearchPropsGet(ctx context.Context, key string) (interface{}, bool) {
	return wizardContext.GetSearchProps(ctx).Get(key)
}
