package helpers

import (
	"bytes"
	"encoding/binary"
	"fmt"
	"io"

	"github.com/golang/protobuf/proto"
)

const MaxProtoSize = 100000

func CutDataIntoProtobufRows(raw []byte) ([][]byte, error) {
	counter := 0
	result := make([][]byte, 0)
	reader := bytes.NewBuffer(raw)

	for {
		counter++
		var pbSize int32

		err := binary.Read(reader, binary.LittleEndian, &pbSize)
		if err == io.EOF {
			break
		}
		if err != nil {
			return nil, fmt.Errorf("error while reading line %v", counter)
		}
		if pbSize <= 0 || pbSize > MaxProtoSize {
			return nil, fmt.Errorf("invalid protobuf size: %v", pbSize)
		}

		line := make([]byte, pbSize)
		_, err = io.ReadAtLeast(reader, line, int(pbSize))
		if err != nil {
			return nil, fmt.Errorf("error while reading bytes in line %v. Cause: %v", counter, err)
		}
		result = append(result, line)
	}
	return result, nil
}

func WritePtotobufIntoBuffer(writer io.Writer, message proto.Message) (err error) {
	raw, err := proto.Marshal(message)
	if err != nil {
		return
	}

	lenRaw := int32(len(raw))

	err = binary.Write(writer, binary.LittleEndian, lenRaw)
	if err != nil {
		return
	}

	err = binary.Write(writer, binary.LittleEndian, raw)
	return
}
