package helpers

import (
	"regexp"
	"strings"
	"unicode"
)

var (
	wordCutter = regexp.MustCompile(`[ \-—().]+`)
)

func Normalize(text string) string {
	text = strings.ToLower(text)
	return strings.Replace(text, "ё", "е", -1)
}

func CutOnWords(text string) []string {
	return wordCutter.Split(text, -1)
}

func IsDigit(value string) bool {
	if len(value) == 0 {
		return false
	}
	for _, char := range value {
		if !unicode.IsDigit(char) {
			return false
		}
	}
	return true
}

func AnyString(values ...string) string {
	for _, value := range values {
		if value != "" {
			return value
		}
	}
	return ""
}

func OptionalString(value string) *string {
	if value == "" {
		return nil
	}
	return &value
}
