package consts

var currencyCodeByNationalVersion = map[string]string{
	"ru":  "RUR",
	"ua":  "UAH",
	"kz":  "KZT",
	"by":  "BYR",
	"tr":  "TRY",
	"com": "EUR",
}

func GetCurrencyCodeByNationalVersion(nationalVersion string) string {
	if code, ok := currencyCodeByNationalVersion[nationalVersion]; ok {
		return code
	}
	return currencyCodeByNationalVersion["ru"]
}
