package containers

type SetOfInterfaceByText map[string]SetOfInterface

func (mapper SetOfInterfaceByText) Add(text string, id int) {
	mapper.EnsureKey(text)
	mapper[text].Add(id)
}

func (mapper SetOfInterfaceByText) Extend(other SetOfInterfaceByText) {
	for key, value := range other {
		mapper.EnsureKey(key)
		mapper[key].Extend(value)
	}
}

func (mapper SetOfInterfaceByText) EnsureKey(key string) {
	if _, found := mapper[key]; !found {
		mapper[key] = make(SetOfInterface)
	}
}
